//
//  MCBlueprintManager.h
//  MCFoundation
//
//  Created by Michael Clark on 17/10/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

@class MCPObjectContext;
@class MCPObjectBlueprint;

@interface MCBlueprintManager : NSObject {
	MCPObjectContext*    __objectContext;  // weak referenced
}

- (id)initWithObjectContext: (MCPObjectContext*)anObjectContext;


- (NSArray*)blueprintsForEntityNamed: (NSString*)anEntityName;

- (MCPObjectBlueprint*)createAndAddNewBlueprintForEntityNamed: (NSString*)anEntityName named: (NSString*)aName;

- (MCPObjectContext *)objectContext;
- (void)setObjectContext:(MCPObjectContext *)anObjectContext;

@end
